#include <bits/stdc++.h>
#define MAX_N 100005
#define ll long long int

using namespace std;

int p[MAX_N];
vector<int> graph[MAX_N];
vector<pair<int, ll>> g[MAX_N];
int level[MAX_N];
bool visited[MAX_N];
ll d[MAX_N];
vector<vector<int>> paths[20];
vector<int> curr_path;

void dfs(int curr_node, int prev_node, int curr_l) {
    p[curr_node] = prev_node;
    level[curr_node] = curr_l;
    for(auto iter : graph[curr_node]) {
        if(iter != prev_node) {
            dfs(iter, curr_node, curr_l + 1);
        }
    }
}

void solve(int curr_node, int start_node) {
    if(curr_node == 1) {
        paths[start_node].push_back(curr_path);
        return ;
    }
    ll min_neighbour = numeric_limits<ll>::max();
    for(auto iter : g[curr_node]) {
        if(!visited[iter.first] && min_neighbour > d[iter.first] + iter.second) {
            min_neighbour = d[iter.first] + iter.second;
        }
    }
    for(auto iter : g[curr_node]) {
        if(!visited[iter.first] && min_neighbour == d[iter.first] + iter.second) {
            curr_path.push_back(iter.first);
            visited[iter.first] = true;
            solve(iter.first, start_node);
            visited[iter.first] = false;
            curr_path.pop_back();
        }
    }
}

void Putevi(int N, int M, int Q, int* U, int* V, int* W, int* X, int* Y, int* Ans) {
    if(M <= 15 && Q <= 1000) {
        for(int i = 1; i <= M; i++) {
            g[U[i]].push_back({V[i], W[i]});
            g[V[i]].push_back({U[i], W[i]});
        }
        priority_queue<pair<ll, int>> q;
        d[1] = 0;
        for(int i = 2; i <= N; i++) {
            d[i] = numeric_limits<ll>::max();
        }
        q.push({0, 1});
        while(!q.empty()) {
            int curr = q.top().second;
            q.pop();
            visited[curr] = true;
            for(auto iter : g[curr]) {
                if(!visited[iter.first] && d[iter.first] > d[curr] + iter.second) {
                    d[iter.first] = d[curr] + iter.second;
                    q.push({-d[iter.first], iter.first});
                }
            }
        }
        for(int i = 1; i <= N; i++) {
            fill(visited, visited + N + 1, false);
            visited[i] = true;
            curr_path.push_back(i);
            solve(i, i);
            curr_path.clear();
        }
        for(int i = 1; i <= Q; i++) {
            int grad1 = X[i];
            int grad2 = Y[i];
            int ans = INT_MAX;
            for(auto v1 : paths[grad1]) {
                for(auto v2 : paths[grad2]) {
                    int cnt = 0;
                    for(auto iter1 : v1) {
                        for(auto iter2 : v2) {
                            if(iter1 == iter2) {
                                cnt++;
                            }
                        }
                    }
                    ans = min(ans, cnt);
                }
            }
            Ans[i] = ans;
        }
        return ;
    }
    if(M != N - 1) {
        return ;
    }
    for(int i = 1; i <= M; i++) {
        graph[U[i]].push_back(V[i]);
        graph[V[i]].push_back(U[i]);
    }
    dfs(1, -1, 1);
    for(int i = 1; i <= Q; i++) {
        int grad1 = X[i], grad2 = Y[i];
        while(level[grad1] != level[grad2]) {
            if(level[grad1] > level[grad2]) {
                grad1 = p[grad1];
            } else {
                grad2 = p[grad2];
            }
        }
        while(grad1 != grad2) {
            grad1 = p[grad1];
            grad2 = p[grad2];
        }
        Ans[i] = level[grad1];
    }
}